;*******************************
;*    DEMONTRATION PROGRAM 6   *
;*        DISPLAY 8x8          *
;*******************************
;
            ORG    8000H
U25PA       EQU    0E0B0H
U25PB       EQU    0E0B1H
U25PC       EQU    0E0B2H
U25CTRL     EQU    0E0B3H
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
U21PA       EQU    0E0B8H
U21PB       EQU    0E0B9H
U21PC       EQU    0E0BAH
U21CTRL     EQU    0E0BBH
SEG_PORT    EQU    U21PB
SCAN_KYDP   EQU    27H
BCD_HEX     EQU    5               ;System call
CLRSCR      EQU    7               ;   "     "
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
MOTORBUF    EQU    22H             ;Port buffer of relay
SYSCALL     EQU    0030H
DISBUF      EQU    9F00H

CP3DEM6:    MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    DPTR,#U25CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    P2,DPH
            MOV    DPTR,#U25PA
            MOV    R0,DPL         ;P2:R0 = Data
            INC    DPTR
            MOV    R1,DPL         ;P2:R1 = Scan (row)
            MOV    PSW,#0

START:      MOV    A,#CLRSCR      ;Clear screen
            LCALL  SYSCALL
            LCALL  PRINT
            ;"Auto-d"
            DB     77H,1CH,78H,5CH,40H,5EH,00
            MOV    DPTR,#DEFAULT
            PUSH   DPH
            PUSH   DPL
            MOV    DPTR,#STRG_BUF
            POP    ACC
            MOVX   @DPTR,A
            INC    DPTR
            POP    ACC
            MOVX   @DPTR,A

WAIT_KEY:   MOV    A,#SCAN_KYDP
            LCALL  SYSCALL
            CJNE   A,#13H,CP11
            SJMP   PROG_D           ;Program Display
CP11:       CJNE   A,#11H,WAIT_KEY
            MOV    DPTR,#STRG_BUF
            MOV    A,#00H
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,#95H
            MOVX   @DPTR,A

PROG_D:     LCALL  CLR_SCR
            LCALL  STRG_L           ;Move string to left
            LCALL  STRG_R           ;Move string to right
            LCALL  SHIFT_UP
            LCALL  SHIFT_DWN
            LCALL  SLIDE_L
            LCALL  CLR_SCR
            LCALL  SLIDE_R
            SJMP   PROG_D

;*******************************
;*      Move string to left    *
;*******************************
;
STRG_L:     MOV    DPTR,#STRG_BUF
            MOVX   A,@DPTR
            PUSH   ACC
            INC    DPTR
            MOVX   A,@DPTR
            MOV    DPH,A
            POP    DPL
            INC    DPTR             ;Skip length of data
STRG_L4:    MOVX   A,@DPTR
            CJNE   A,#0,STRG_L1
            SJMP   OUT_STRG
STRG_L1:    PUSH   DPL
            PUSH   DPH
            MOV    DPTR,#REAR
            LCALL  WRITE_CHR
            MOV    R4,#8
STRG_L3:    MOV    B,#0A0H
            LCALL  SHIFT_L
STRG_L2:    LCALL  DISPLAY
            DJNZ   B,STRG_L2
            DJNZ   R4,STRG_L3
            POP    DPH
            POP    DPL
            INC    DPTR
            SJMP   STRG_L4
OUT_STRG:   MOV    R4,#8
OUT_STRG1:  LCALL  SHIFT_L
            MOV    B,#0B0H
OUT_STRG2:  LCALL  DISPLAY
            DJNZ   B,OUT_STRG2
            DJNZ   R4,OUT_STRG1
            RET

DEFAULT:    DB     04          ;Length of string
            DB     'TEST',00   ;

;*******************************
;*      Move string to right   *
;*******************************
;
STRG_R:     MOV    DPTR,#STRG_BUF
            MOVX   A,@DPTR
            PUSH   ACC
            INC    DPTR
            MOVX   A,@DPTR
            MOV    DPH,A
            POP    DPL
            MOVX   A,@DPTR
            MOV    R5,A           ;Counter
            ADD    A,DPL          ;Advance to end of string
            MOV    DPL,A
            JNC    STRG_R4
            MOV    A,DPH
            ADDC   A,#0
            MOV    DPH,A

STRG_R4:    MOVX   A,@DPTR        ;Get data
STRG_R1:    PUSH   DPL
            PUSH   DPH
            MOV    DPTR,#FRONT
            LCALL  WRITE_CHR
            MOV    R4,#8
STRG_R3:    MOV    B,#0A0H
            LCALL  SHIFT_R
STRG_R2:    LCALL  DISPLAY
            DJNZ   B,STRG_R2
            DJNZ   R4,STRG_R3
            POP    DPH
            POP    DPL
            MOV    A,DPL          ;Decrease DPTR
            JNZ    DEC_DPL
            DEC    DPH
DEC_DPL:    DEC    DPL
            DJNZ   R5,STRG_R4
OUT_STRGR:  MOV    R4,#8
OUT_STRGR1: LCALL  SHIFT_R
            MOV    B,#0B0H
OUT_STRGR2: LCALL  DISPLAY
            DJNZ   B,OUT_STRGR2
            DJNZ   R4,OUT_STRGR1
            RET

;*****************************
;*        Delay 1 msec.      *
;* INPUT   B= Time(milli sec)*
;*****************************
;
MSEC_DLY:   MOV    DPTR,#65536-152
MD1:        INC    DPTR
            MOV    A,DPH
            ORL    A,DPL
            JNZ    MD1
            RET

;*****************************************
;*  Move data following "CALL PRINT"     *
;*  to display buffer.                   *
;*  Usage: LCALL PRINT                   *
;*         DB   'xxxx',00                *
;*  Register : R0                        *
;*  Note : End of text by fill to end 00 *
;*         Space on disply by code 20h.  *
;*****************************************
;
PRINT:      MOV    DPTR,#DISBUF
            MOV    P2,DPH
            MOV    R0,DPL         ;P2:R0 = Destination
            POP    DPH            ;Point to data to print
            POP    DPL
PRNTD1:     CLR    A
            MOVC   A,@A+DPTR
            JZ     END_PRN        ;End of text
            CJNE   A,#20H,PRNTD2
            CLR    A
PRNTD2:     MOVX   @R0,A          ;Write to display buffer
            INC    DPTR
            INC    R0
            SJMP   PRNTD1
END_PRN:    JMP    @A+DPTR        ;Return
            ;End of print
            ;Return to main

;*********************************
;*        DISPLAY ROUTINE        *
;*********************************
;
DISPLAY:    PUSH   PSW
            SETB   RS0             ;Select bank 1
            MOV    DPTR,#U25PA
            MOV    P2,DPH
            MOV    R0,DPL         ;P2:R0 = Data
            INC    DPTR
            MOV    R1,DPL         ;P2:R1 = Row scan
            MOV    DPTR,#DISBUF2
            MOV    R2,#1
            MOV    R3,#8

DP2:        CLR    A
            MOVX   @R1,A          ; Clear scan row
            MOVX   A,@DPTR        ; Read Data from buffer
            INC    DPTR           ; Bump Pointer
            INC    DPTR
            INC    DPTR
            MOVX   @R0,A          ; Write data to port A
            MOV    A,R2
            MOVX   @R1,A
            RL     A
            MOV    R2,A
            LCALL  ROW_DLY
            DJNZ   R3,DP2
            CLR    A
            MOVX   @R1,A
OUT_DSP:    POP    PSW
            RET

ROW_DLY:    PUSH   ACC
            PUSH   B
            MOV    B,#10
RD1:        DEC    B
            MOV    A,B
            JNZ    RD1
            POP    B
            POP    ACC
            RET


;*******************************
;*        CLEAR SCREEN         *
;*******************************
CLR_SCR:    PUSH   DPL
            PUSH   DPH
            MOV    DPTR,#FRONT
            MOV    R0,#24
F1:         CLR    A
            MOVX   @DPTR,A
            INC    DPTR
            DJNZ   R0,F1
            POP    DPH
            POP    DPL
            RET

;**************************************
;*   Get address of character         *
;*   Input  = ACC = Ascii of character*
;*   Output = DPTR point to 1st byte  *
;**************************************
;
GET_CHR:    PUSH   B
            MOV    DPTR,#FONT
            CLR    CY
            SUBB   A,#20H      ; Because font start at ASCII 20h
            MOV    B,#08
            MUL    AB
            ADD    A,DPL       ; Low byte of FONT table
            MOV    DPL,A
            MOV    A,B
            ADDC   A,DPH
            MOV    DPH,A
            POP    B
            RET

;*************************************
;*    FILL  FONT TO DISPLAY BUFFER   *
;*  Input   : DPTR Contain addres of *
;*            1st byte of table .    *
;*            R1:R0 = Addres of      *
;*                    display buffer *
;*************************************
FILL_FONT:  MOV   P2,R1
            MOV   R2,#8
FC1:        MOVX  A,@DPTR       ; Get font
            MOVX  @R0,A         ; Fill display buffer
            MOV   A,#3         ;
            ADD   A,R0
            MOV   R0,A
            MOV   A,R1
            ADDC  A,#0
            MOV   R1,A
            MOV   P2,A
            INC   DPTR
            DJNZ  R2,FC1
            RET

;*************************************
;*     Write character to display    *
;* INPUT  : DPTR=Position on display *
;*          ACC=Character            *
;*************************************
WRITE_CHR:  MOV    R1,DPH
            MOV    R0,DPL
            LCALL  GET_CHR
            LCALL  FILL_FONT
            RET

;*************************************
;*         Shift left buffer         *
;*************************************
;
SHIFT_L:    MOV    DPTR,#REAR
            MOV    P2,DPH
            MOV    R0,DPL
            MOV    DPTR,#DISBUF2
            MOV    R2,#8
SHF_L1:     MOVX   A,@R0          ;Get source
            RLC    A
            CLR    ACC.0
            MOVX   @R0,A
            MOVX   A,@DPTR
            RLC    A
            MOVX   @DPTR,A        ;Write to destination
            MOV    A,R0           ;Advance pointer
            ADD    A,#3
            MOV    R0,A
            JNC    SHF_L2
            INC    P2
SHF_L2:     INC    DPTR
            INC    DPTR
            INC    DPTR
            DJNZ   R2,SHF_L1
            RET

;*************************************
;*         Shift Right buffer        *
;*************************************
;
SHIFT_R:    MOV    DPTR,#FRONT
            MOV    R1,DPH
            MOV    P2,DPH
            MOV    R0,DPL
            MOV    DPTR,#DISBUF2
            MOV    R2,#8
SHF_R1:     MOVX   A,@R0          ;Get source
            RRC    A
            CLR    ACC.7
            MOVX   @R0,A
            MOVX   A,@DPTR
            RRC    A
            MOVX   @DPTR,A        ;Write to destination
            MOV    A,R0           ;Advance pointer
            ADD    A,#3
            MOV    R0,A
            JNC    SHF_R2
            INC    P2
SHF_R2:     INC    DPTR
            INC    DPTR
            INC    DPTR
            DJNZ   R2,SHF_R1
            RET

;*******************************
;*      Shift up display       *
;*******************************
;
SHIFT_UP:   MOV    DPTR,#STRG_BUF
            MOVX   A,@DPTR
            PUSH   ACC
            INC    DPTR
            MOVX   A,@DPTR
            MOV    DPH,A
            POP    DPL
            INC    DPTR            ;Skip length
            MOVX   A,@DPTR         ;Get data
            MOV    DPTR,#DISBUF2
            LCALL  WRITE_CHR
            MOV    B,#0
SH_UP2:     LCALL  DISPLAY
            DJNZ   B,SH_UP2
            MOV    R3,#8
            MOV    DPTR,#UP_DSP
            MOV    R5,DPH
            MOV    R4,DPL
SHF_UP0:    MOV    B,#0F0H
SHF_UP1:    LCALL  DISPLAY
            DJNZ   B,SHF_UP1
            LCALL  SCROLL_UP
            DJNZ   R3,SHF_UP0
            RET

SCROLL_UP:  MOV    DPTR,#DISBUF2+3
            MOV    P2,DPH
            MOV    R0,DPL           ;Source
            MOV    DPTR,#DISBUF2    ;Destination
            MOV    R2,#7
            MOVX   A,@DPTR
            PUSH   DPL
            PUSH   DPH
            MOV    DPH,R5
            MOV    DPL,R4
            MOVX   @DPTR,A
            INC    DPTR
            MOV    R5,DPH
            MOV    R4,DPL
            POP    DPH
            POP    DPL

SCRL_UP0:   MOVX   A,@R0
            MOVX   @DPTR,A
            MOV    A,R0
            ADD    A,#3
            MOV    R0,A
            JNC    SCRL_UP1
            INC    P2
SCRL_UP1:   INC    DPTR
            INC    DPTR
            INC    DPTR
            DJNZ   R2,SCRL_UP0
            MOV    A,R0
            CLR    CY
            SUBB   A,#3
            MOV    R0,A
            JNC    SCRL_UP2
            DEC    P2
SCRL_UP2:   CLR    A
            MOVX   @R0,A
            RET

;***********************************
;*        Shift down display       *
;***********************************
;
SHIFT_DWN:  MOV    DPTR,#UP_DSP+7
            MOV    R2,DPH
            MOV    R0,DPL
            MOV    R3,#8
SCRL_DW0:   MOV    P2,R2
            MOVX   A,@R0
            MOV    DPTR,#DISBUF2
            MOVX   @DPTR,A
            MOV    A,R0
            JNZ    SCRL_DW1
            DEC    R2
SCRL_DW1:   DEC    R0
            MOV    B,#0F0H
SCRL_DW2:   LCALL  DISPLAY
            DJNZ   B,SCRL_DW2
            LCALL  SCROLL_DWN
            DJNZ   R3,SCRL_DW0
            MOV    R3,#7
SCRL_DW3:   MOV    B,#0F0H
            LCALL  SCROLL_DWN
SCRL_DW4:   LCALL  DISPLAY
            DJNZ   B,SCRL_DW4
            DJNZ   R3,SCRL_DW3
            RET

SCROLL_DWN: MOV    DPTR,#DISBUF2+21
            MOV    P2,DPH
            MOV    R1,DPL
            MOV    DPTR,#DISBUF2+18
            MOV    R6,DPL
            MOV    R7,DPH
            MOV    R5,#7
SCRLDWN0:   MOVX   A,@DPTR       ;Read source data
            MOVX   @R1,A         ;Write to destination
            DJNZ   R5,SCRLDWN1
            CLR    A
            MOVX   @DPTR,A
            SJMP   OUT_SCRL
SCRLDWN1:   MOV    A,R1
            CLR    CY
            SUBB   A,#3
            MOV    R1,A
            JNC    SCRLDWN3
            DEC    P2
SCRLDWN3:   MOV    A,DPL
            CLR    CY
            SUBB   A,#3
            JNC    SCRLDWN2
            DEC    DPH
SCRLDWN2:   MOV    DPL,A
            SJMP   SCRLDWN0
OUT_SCRL:   RET


;**********************************
;*    Slide display to the left   *
;**********************************
;
SLIDE_L:    MOV    R5,#0
            MOV    R7,#8
SLIDE_L0:   MOV    DPTR,#UP_DSP
            MOV    R3,DPH
            MOV    R0,DPL
            MOV    DPTR,#DISBUF2
            MOV    R4,DPH
            MOV    R1,DPL
            MOV    R6,#8
            MOV    A,R5
            SETB   CY
            RLC    A
            MOV    R5,A
SLIDE_L1:   MOV    P2,R3
            MOVX   A,@R0           ;Read data
            ANL    A,R5
            MOV    P2,R4
            MOVX   @R1,A
            INC    R0
            MOV    A,R0
            JNZ    SLIDE_L2
            INC    R3
SLIDE_L2:   MOV    A,R1
            ADD    A,#3
            MOV    R1,A
            JNC    SLIDE_L3
            INC    R4
SLIDE_L3:   DJNZ   R6,SLIDE_L1
            MOV    B,#0
SLIDE_L4:   LCALL  DISPLAY
            DJNZ   B,SLIDE_L4
            DJNZ   R7,SLIDE_L0
            RET

;**********************************
;*    Slide display to the right  *
;**********************************
;
SLIDE_R:    MOV    R5,#0
            MOV    R7,#8
SLIDE_R0:   MOV    DPTR,#UP_DSP
            MOV    R3,DPH
            MOV    R0,DPL
            MOV    DPTR,#DISBUF2
            MOV    R4,DPH
            MOV    R1,DPL
            MOV    R6,#8
            MOV    A,R5
            SETB   CY
            RRC    A
            MOV    R5,A
SLIDE_R1:   MOV    P2,R3
            MOVX   A,@R0           ;Read data
            ANL    A,R5
            MOV    P2,R4
            MOVX   @R1,A
            INC    R0
            MOV    A,R0
            JNZ    SLIDE_R2
            INC    R3
SLIDE_R2:   MOV    A,R1
            ADD    A,#3
            MOV    R1,A
            JNC    SLIDE_R3
            INC    R4
SLIDE_R3:   DJNZ   R6,SLIDE_R1
            MOV    B,#0
SLIDE_R4:   LCALL  DISPLAY
            DJNZ   B,SLIDE_R4
            DJNZ   R7,SLIDE_R0
            RET


FONT:       DB 00H,00H,00H,00H,00H,00H,00H,00H    ; Null
            DB 10H,10H,10H,10H,00H,00H,10H,00H    ; !
            DB 28H,28H,28H,00H,00H,00H,00H,00H    ; "
            DB 28H,28H,7CH,28H,7CH,28H,28H,00H    ; #
            DB 10H,3CH,50H,38H,14H,78H,10H,00H    ; $
            DB 60H,64H,08H,10H,20H,4CH,0CH,00H    ; %
            DB 30H,48H,50H,20H,54H,48H,34H,00H    ; &
            DB 30H,10H,20H,00H,00H,00H,00H,00H    ; '
            DB 08H,10H,20H,20H,20H,10H,08H,00H    ; (
            DB 20H,10H,08H,08H,08H,10H,20H,00H    ; )
            DB 00H,10H,54H,38H,54H,10H,00H,00H    ; *
            DB 00H,10H,10H,7CH,10H,10H,00H,00H    ; +
            DB 00H,00H,00H,00H,30H,10H,20H,00H    ; ,
            DB 00H,00H,00H,7CH,00H,00H,00H,00H    ; -
            DB 00H,00H,00H,00H,00H,30H,30H,00H    ; .
            DB 00H,04H,08H,10H,20H,40H,00H,00H    ; /
            DB 38H,44H,4CH,54H,64H,44H,38H,00H    ; 0
            DB 10H,30H,10H,10H,10H,10H,38H,00H    ; 1
            DB 38H,44H,04H,08H,10H,20H,7CH,00H    ; 2
            DB 7CH,08H,10H,08H,04H,44H,38H,00H    ; 3
            DB 08H,18H,28H,48H,7CH,08H,08H,00H    ; 4
            DB 7CH,40H,78H,04H,04H,44H,38H,00H    ; 5
            DB 18H,20H,40H,78H,44H,44H,38H,00H    ; 6
            DB 7CH,04H,08H,10H,20H,20H,20H,00H    ; 7
            DB 38H,44H,44H,38H,44H,44H,38H,00H    ; 8
            DB 38H,44H,44H,3CH,04H,08H,30H,00H    ; 9
            DB 00H,30H,30H,00H,30H,30H,00H,00H    ; :
            DB 00H,30H,30H,00H,30H,10H,20H,00H    ; ;
            DB 08H,10H,20H,40H,20H,10H,08H,00H    ; <
            DB 00H,00H,7CH,00H,7CH,00H,00H,00H    ; =
            DB 20H,10H,08H,04H,08H,10H,20H,00H    ; >
            DB 38H,44H,04H,08H,10H,00H,10H,00H    ; ?
            DB 38H,44H,04H,34H,54H,54H,38H,00H    ; @
UPPER:      DB 38H,44H,44H,7CH,44H,44H,44H,00H    ; A
            DB 78H,44H,44H,78H,44H,44H,78H,00H    ; B
            DB 38H,44H,40H,40H,40H,44H,38H,00H    ; C
            DB 70H,48H,44H,44H,44H,48H,70H,00H    ; D
            DB 7CH,40H,40H,78H,40H,40H,7CH,00H    ; E
            DB 7CH,40H,40H,78H,40H,40H,40H,00H    ; F
            DB 38H,44H,40H,5CH,44H,44H,3CH,00H    ; G
            DB 44H,44H,44H,7CH,44H,44H,44H,00H    ; H
            DB 38H,10H,10H,10H,10H,10H,38H,00H    ; I
            DB 1CH,08H,08H,08H,08H,48H,30H,00H    ; J
            DB 44H,48H,50H,60H,50H,48H,44H,00H    ; K
            DB 40H,40H,40H,40H,40H,40H,7CH,00H    ; L
            DB 44H,6CH,54H,54H,44H,44H,44H,00H    ; M
            DB 44H,44H,64H,54H,4CH,44H,44H,00H    ; N
            DB 38H,44H,44H,44H,44H,44H,38H,00H    ; O
            DB 78H,44H,44H,78H,40H,40H,40H,00H    ; P
            DB 38H,44H,44H,44H,54H,48H,34H,00H    ; Q
            DB 78H,44H,44H,78H,50H,48H,44H,00H    ; R
            DB 3CH,40H,40H,38H,04H,04H,78H,00H    ; S
            DB 7CH,10H,10H,10H,10H,10H,10H,00H    ; T
            DB 44H,44H,44H,44H,44H,44H,38H,00H    ; U
            DB 44H,44H,44H,44H,44H,28H,10H,00H    ; V
            DB 44H,44H,44H,54H,54H,54H,28H,00H    ; W
            DB 44H,44H,28H,10H,28H,44H,44H,00H    ; X
            DB 44H,44H,44H,28H,10H,10H,10H,00H    ; Y
            DB 7CH,04H,08H,10H,20H,40H,7CH,00H    ; Z
            DB 38H,20H,20H,20H,20H,20H,38H,00H    ; [
            DB 40H,20H,10H,08H,04H,02H,01H,00H    ; \
            DB 38H,08H,08H,08H,08H,08H,38H,00H    ; ]
            DB 10H,28H,44H,00H,00H,00H,00H,00H    ; ^
            DB 00H,00H,00H,00H,00H,00H,7CH,00H    ; _
            DB 20H,10H,08H,00H,00H,00H,00H,00H    ;`
LOWER:      DB 00H,00H,38H,08H,38H,48H,34H,00H    ; a
            DB 40H,40H,58H,64H,44H,44H,78H,00H    ; b
            DB 00H,00H,3CH,40H,40H,40H,3CH,00H    ; c
            DB 04H,04H,34H,4CH,44H,44H,3CH,00H    ; d
            DB 00H,00H,38H,44H,78H,40H,38H,00H    ; e
            DB 18H,24H,20H,70H,20H,20H,20H,00H    ; f
            DB 00H,00H,38H,44H,44H,3CH,04H,38H    ; g
            DB 40H,40H,58H,64H,44H,44H,44H,00H    ; h
            DB 10H,00H,30H,10H,10H,10H,38H,00H    ; i
            DB 00H,08H,00H,08H,08H,28H,10H,00H    ; j
            DB 40H,40H,48H,50H,60H,50H,48H,00H    ; k
            DB 30H,10H,10H,10H,10H,10H,18H,00H    ; l
            DB 00H,00H,68H,54H,54H,54H,44H,00H    ; m
            DB 00H,00H,58H,24H,24H,24H,24H,00H    ; n
            DB 00H,00H,38H,44H,44H,44H,38H,00H    ; o
            DB 00H,00H,70H,48H,48H,70H,40H,40H    ; p
            DB 00H,00H,38H,48H,48H,38H,08H,08H    ; q
            DB 00H,00H,58H,64H,40H,40H,40H,00H    ; r
            DB 00H,00H,38H,40H,38H,04H,78H,00H    ; s
            DB 20H,20H,78H,20H,20H,24H,18H,00H    ; t
            DB 00H,00H,48H,48H,48H,48H,34H,00H    ; u
            DB 00H,00H,44H,44H,28H,28H,10H,00H    ; v
            DB 00H,00H,44H,44H,54H,54H,28H,00H    ; w
            DB 00H,00H,44H,28H,10H,28H,44H,00H    ; x
            DB 00H,00H,48H,48H,48H,38H,08H,70H    ; y
            DB 00H,00H,7CH,08H,10H,20H,7CH,00H    ; z
            DB 08H,10H,10H,20H,10H,10H,08H,00H    ; {
            DB 18H,18H,18H,18H,18H,18H,18H,00H    ; |
            DB 20H,10H,10H,08H,10H,10H,20H,00H    ; }
            DB 00H,00H,00H,32H,4CH,00H,00H,00H    ; ~

            ;RAM Working arear
            ORG    $
FRONT:      DS     1       ;Front display
DISBUF2:    DS     1       ;Display buffer
REAR:       DS     1
            DS     22
UP_DSP:     DS     8       ;Upper side buffer
STRG_BUF:   DS     2       ;Address of string buffer

            END

